/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// If SHOW_TILES is defined then the tile boundaries will be drawn.

// #define SHOW_TILES

/////////////////////////////////////////////////////////////////////////////////

//Epitrochoidal taps by nmz (twitter: @stormoid)

#define time iGlobalTime

/*
	Using Epitrochoidal taps to allow for non-repeating, tileable
	noise, works in any dimensions, but each repeating axis needs
	2 dimensions of noise.

	Examples: 
		-2d noise with 1 repeating dimension = 3d noise needed
		-2d noise with 2 repeating dimensions= 4d noise needed
		-3d noise with 1 repeating dimension = 4d noise needed
		-3d noise with 3 repeating dimensions= 6d noise needed
		etc..

	Here's a link to a plot of the epitrochoidal curve being used to tap the higher
	dimensional textures (hopefully that helps understand what i'm doing):
	http://www.wolframalpha.com/input/?i=parametric+plot+cos(t)-cos(t*4)%2csin(t)-sin(t*4)


	N.B. The tiles produced are only interchangeable on one axis, this
	means you can't just get a random array of those tiles and splat them
	around in multiple dimensions, they need kept in the base order.
*/

//Number of zero passes per full cycles (number of different tiles)
const int passes = 5;
const float zoom = 6.;

const float c= float(passes);

//From tekF: https://www.shadertoy.com/view/ltXGWS
float cells(in vec4 p){
    p = fract(p/2.0)*2.0;   
    p = min( p, 2.0-p );
    return min(length(p),length(p-1.0));
}
float noise4d(in vec4 p)
{
    p*= 2.4;
    p.x += sin(p.z+p.y+p.w+time);
    return pow(cells(p),2.)-.6;
}

float gf = 0.;
float gf2 = 0.;

//Using n+2 dimensional noise to create seamless repetition on two axes
float tap4d(in vec2 p)
{ 
    float x = cos(p.x)-cos(p.x*c);
    float y = sin(p.x)-sin(p.x*c);
    
    float xx = cos(p.y)-cos(p.y*c);
    float yy = sin(p.y)-sin(p.y*c);
    
    vec4 z = vec4(x, xx, y, yy);
    z *= .33;
  
#ifdef SHOW_TILES  
    //for the "debug" lines
    if (cos(p.x) > 0.99995 || cos(p.y) > 0.99995)gf2= 1.;
    if (length(vec2(x,y))< 0.00185*c*zoom || length(vec2(xx,yy))< 0.00185*c*zoom)gf=1.;
#endif
    
    return noise4d(z);
}

void main ( void )
{
    vec2 p = gl_FragCoord.xy / iResolution.xy;
    p.x += time*0.1;

// Uncomment the following lines to get square tiles that are symetrically
// placed about the central horizontal. Leave them commented out for tiles
// that are the same shape as the screen and will tile it with no  partial
// tiles being needed if zoom is even or with half tiles needed if zoom is
// odd.
//
//  p.x *= iResolution.x/iResolution.y;
//  p.y -= 0.05;
    
    p *= zoom;
    vec3 col = vec3(tap4d(p));
    
#ifdef SHOW_TILES  
    if (gf == 1.)col.r += 1.;
    if (gf2 == 1.)col.b += 1.;
#endif
    
	gl_FragColor = vec4 ( col, length(col) );
}